; Frac.asm: program to play around with fractals!????!?
;

        .include "startup.asm"
	.nomlist
	.list


; Zero-page variables

	.zp

ptr:	.ds	2 	; pointer to buffer address
a_cnt:	.ds	1
x_cnt:	.ds	1
sx:	.ds	2
sy:	.ds	2
cursor:	.ds	1	;Which value is being changed?
cursx:	.ds	1
cursy:	.ds	1	;Cursor for the menu...
nmi_count: .ds	1	;Counter for NMIs...
scanline: .ds	2	;Scanline counter
write_flag: .ds 1	;A flag for the gfx-writing function to draw something.
Qwrite_flag: .ds 1	;A flag for Quality Gfx!
Qwrite_buff: .ds 8	;Storage for 8 iteration values
Qwrite_ram: .ds	4	;4 bytes for 8 pixels - 1 tile
Qwrite_address: .ds 2	;2 bytes are all that are needed (maybe?)
restart_flag: .ds 1	;A flag to restart the fractal!
write_add: .ds	2	;Address in VRAM for writing.
write_data: .ds 2	;2 bytes for now...
menu_on: .ds	1	;Is the menu activated?
splash_on: .ds	1	;Splash Screen on first!
box_mode: .ds	1	;Are we using the boxes to zoom?


;----------------

;--- fractal variables -------
itermax: .ds	2	;Maximum Iterations
;-------------------
period_test: .ds 1	;Do a period check if last value was infinite
per_aX:	.ds	4
per_aY:	.ds	4
period:	.ds	1	;Period skip...  should be 16-bit?
per_check: .ds	1	;s/b 16-bit?
xres:	.ds	2	;X-resolution of fractal
yres:	.ds	2	;Y-resolution (usually less than 256)
;------------------- the following MUST be contiguous!
x0_start: .ds	4	;32-bit X start position
y0_start: .ds	4
x_zoom:	.ds	8	;Zoom factor
itermaxpv: .ds	2
itermaxfu: .ds	2
;------------------------- see above note. :-)

horiz_res: .ds	1	;screen resolution 0=256, 1=512?
cycling: .ds	1	;Colour cycling mode
quality: .ds	1	;0=preview, 1=High-quality!
x0_step: .ds	4	;Step for each pixel
y0_step: .ds	4
px:	.ds	2	;Iteration counters
py:	.ds	2
iteration: .ds	2
x_val:	.ds	4	;"X" in the algorithm
y_val:	.ds	4
x0:	.ds	4
y0:	.ds	4
xtemp:	.ds	4
xx:	.ds	4	;X squared
yy:	.ds	4	;Y squared
xx_yy:	.ds	4	;x sq times y sq.
TEMP64A: .ds	8
TEMP64B: .ds	8	;Temp variables
tempidx: .ds	1
tempvar1: .ds	1
howdy:	.ds	1
remaining: .ds	2	;Remaining # of tiles/pixels to draw!


;----------------
resultsign: .ds 1	;Sign for the result of DIV/MUL
multpart1: .ds  4	;32-bits!
multpart2: .ds  4	;32-bits!
multresult: .ds 8	;64-bits!

DVDQUO:	.ds	8	;Division Quotient 
DVDR:	.ds	16	;Division Remainder?
MULR:	.ds	8	;Multiplicand?
ADDDP:	.ds	1	;A counter during division


zp1:	.ds	2   		;8 bytes zp index addresses
zp2:	.ds	2
zp3:	.ds	2
zp4:	.ds	2

	.bss
satb	.ds 512	; the local SATB

boxposx: .ds	4	;Position (in fractal) for initial zoom box
boxposy: .ds	4
boxzoom: .ds	8	;The new zoom factor
box1sprx: .ds	2	;Sprite positions
box1spry: .ds	2
box2sprx: .ds	2
box2spry: .ds	2
boxwidth: .ds	1	;The width of the box...
joy_delay: .ds	1	;A delay for the joystick
colouridx: .ds	1	;The index into a palette
colourcur: .ds	1	;
preset:	.ds	1	;The preset number.

boxside1y =	satb+$80		;Sprite 16!
boxside1x =	satb+$82
boxside2y =	satb+$88		;Sprite 17!
boxside2x =	satb+$8A
boxside3y =	satb+$90		;Sprite 18!
boxside3x =	satb+$92
boxside4y =	satb+$98		;Sprite 19!
boxside4x =	satb+$9A
tab1	=	$3800 			;2 kbytes square tables
tab2	=	$3A00			;From $3800...
tab3	=	$3C00
tab4	=	$3E00
SPRXINIT =	$0020
SPRYINIT =	$00E9
FIRSTJOYDELAY = $14
JOYDELAY =	$04
CYCDELAY1 =	$20
CYCDELAY2 =	$08


	;...

SCREEN_OFF	.macro
	vreg  #5
	st1   #$0C
	st2   #$00
		.endm
SCREEN_ON	.macro
	vreg  #5
	st1   #$CC
	st2   #$00
		.endm


;--- CODE area ----------

	.code		;In INIT Bank ($E000-$FFFF!)
;**************************************
	.include "FractalMath.asm"
	.include "Video_Work.asm"
	.include "fastmath.asm"
	.include "divide.asm"
;**************************************
	.bank  MAIN_BANK
	.org   $6000
howdychr2a:
	.vram	$5000
	.incchr "Gfx\howdy.pcx",0,128,32,4	;All!
howdychr2b:
	.vram	$4000
	.incchr "Gfx\howdy.pcx",0,64,32,4	;All!
;:::::::::::::::::::::::::::::::::::::::::::::
	.bank MAIN_BANK+1
	.org  $C000

main:	
	SCREEN_OFF
	vec_off #VSYNC
	vec_off #HSYNC
    	JSR mult_init    ;first build the tables tab1..tab4
                	;and init zp1-zp4
	lda	#1
	sta	<restart_flag	;"Restart"
	sta	<splash_on
	sta	<menu_on
	sta	<horiz_res	;1 = 512 pixels

	lda	Curs_Default_Tbl
	sta	<cursx
	stz	<cursy
	stz	<quality
;	stz	<Qwrite_flag
	stz	<box_mode
	stz	<howdy
	stz	<cycling
	stz	colouridx
	stz	preset

	jsr	Init_Fractal_Vars
	jsr	setup_video
	jsr	Print_All_Panels
	jsr	Draw_Splash_Screen


	setvec #VSYNC,vsync_proc
	vec_on #VSYNC
	setvec #HSYNC,hsync_proc
	vec_on #HSYNC
	SCREEN_ON

.here:
	bbr0	<restart_flag,.here		;Wait until ordered to restart.
	jsr	Init_Fractal	;Initialize Fractal
	stz	<restart_flag	;Don't restart!
	jsr	Generate_Fractal
	bra    .here

	;...

vsync_proc:
	bbr0	<box_mode,.no_move_sprites
	jsr	Move_Box_Sides
	jsr	Update_Satb_BLOCKTRANSFER
.no_move_sprites:
	st0   #6		; restart the scanline counter on the first
	stw   #$40,video_data	; line
	stw   #$40,<scanline
	st0	#7
	stwz	video_data
	st0	#8
	stwz	video_data	;Clear scrolling!
;---------
	inc	<nmi_count
;	jsr	Write_Gfx
	jsr	TestJoypad	;This changes the values and cursor
	jsr	Update_Panel_Readout
;------------
	lda	<cycling
	beq	.no_cycle_colours
	jsr	ColourCycle
.no_cycle_colours:

	rts

hsync_proc:

.scanline:
	st0   #6
	incw  <scanline
	stw   <scanline,video_data
	bbr0	<splash_on,.no_hsync_splash
	cmpw	#$005D,<scanline	;is it at ~128?
	bne	.no_hsync_show_menu
	;Now, display the splash screen
	st0	#8		;Set Y-scroll!
	stw	#$0147,video_data
	st0	#7		;Set X-scroll!
	stwz	video_data
	bra	.no_hsync_show_menu
.no_hsync_splash:
	bbr0	<menu_on,.no_hsync_show_menu
	cmpw	#$00E9,<scanline	;is it at ~128?
	bne	.no_hsync_show_menu
	;Now, display the menu
	st0	#8		;Set Y-scroll!
	stw	#$00FF,video_data
	st0	#7		;Set X-scroll!
	stw	#$FFFF,video_data
.no_hsync_show_menu:
	jsr	Write_Gfx
	rts

;[ USER DATA ]
Curs_Limit_Tbl:
	.db $08,$08,$10,$04,$04,$01,$01,$01
Curs_Default_Tbl:
	.db $02,$02,$03,$02,$02,$00,$00,$00

;==============================================================================
TestJoypad:
	bbr0	<splash_on,.no_splash_joy	;Test for splash screen
	lda	joytrg		;Check joypad triggered
	beq	.splashjoyend
	stz	<splash_on
	jmp	posnspr
.splashjoyend:
	jmp	joy_joy_end
;-------
.no_splash_joy:
	tst	#$20,joytrg	;This is RIGHT
	beq	.NoPushRight
	bbr0	<box_mode,.no_box_right
	;We are safely ???? in box mode, so move sprite!
	jsr	Box_Move_Right
	jmp	updspr
;----------------
.no_box_right:
	bbr0	<menu_on,.rt_nomenu
	inc	<cursx
	ldx	<cursy	;Different limit for each cursor
	lda	Curs_Limit_Tbl,X
	cmp	<cursx
	bne	.no_curs_problem
	stz	<cursx		;Wrap cursor!
.no_curs_problem:
	jmp	posnspr
.rt_nomenu:		;Menu is off, test quality drawing...
	bbs0	<quality,.NoPushRight
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushRight
	tst	#$80,joytrg	;This is LEFT
	beq	.NoPushLeft
	bbr0	<box_mode,.no_box_left
	;We are safely ???? in box mode, so move sprite!
	jsr	Box_Move_Left
	jmp	updspr
;--------------
.no_box_left:
	bbr0	<menu_on,.lf_nomenu
	dec	<cursx
	lda	<cursx
	cmp	#$FF
	bne	.no_curs_underflow
	ldx	<cursy	;Different limit for each cursor
	lda	Curs_Limit_Tbl,X
	dec	a
.lwrite_reg_var:
	sta	<cursx		;Wrap cursor!
.no_curs_underflow:
	jmp	posnspr
.lf_nomenu:		;Menu is off, test quality drawing...
	bbs0	<quality,.NoPushLeft
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushLeft
	tst	#$10,joytrg	;This is UP
	beq	.NoPushUp
	bbr0	<box_mode,.no_box_up
	;We are safely ???? in box mode, so move sprite!
	jsr	Box_Move_Up
	jmp	updspr
;--------------
.no_box_up:
	bbr0	<menu_on,.up_nomenu
	dec	<cursy
	lda	<cursy
	cmp	#$FF
	bne	.no_cursy_under
	lda	#$07
	sta	<cursy
.no_cursy_under:
	tax
	lda	Curs_Default_Tbl,X	;Load default position
	sta	<cursx
	jmp	posnspr
.up_nomenu:		;Menu is off, test quality drawing...
	bbs0	<quality,.NoPushUp
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushUp
	tst	#$40,joytrg	;This is DOWN
	beq	.NoPushDown
	bbr0	<box_mode,.no_box_down
	;We are safely ???? in box mode, so move sprite!
	jsr	Box_Move_Down
	jmp	updspr
;--------------
.no_box_down:
	bbr0	<menu_on,.dn_nomenu
	inc	<cursy
	lda	<cursy
	cmp	#$08
	bne	.no_curs_y_prob
	cla
	sta	<cursy
.no_curs_y_prob:
	tax
	lda	Curs_Default_Tbl,X	;Load default position
	sta	<cursx
	jmp	posnspr
.dn_nomenu:		;Menu is off, test quality drawing...
	bbs0	<quality,.NoPushDown
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushDown
	tst	#$08,joytrg	;This is RUN
	beq	.NoPushRun
	bbr0	<box_mode,.render_hq
	;In Box mode, so, redraw fractal (keep panel off!)
;;;;;;;;;;;;;;;;;;;;;;	smb0	<menu_on
	jsr	Copy_Box_Frac_Vars
	jsr	Print_All_Panels
	smb0	<restart_flag
	jsr	Setup_Box_Sprites
	spr_set #0,satb
	spr_x #$0
	jmp	joy_end
;----------------
.render_hq:
	bbs0	<quality,.no_restart_quality
	smb0	<quality	;Set to high-quality!
	jsr	Init_Quality_Screen
	jsr	Setup_Horizontal_Res_Vars
	jsr	Check_Sixes
	smb0	<restart_flag	;Set to restart the fractal!
	stz	<menu_on	;Menu is off!
.no_restart_quality

;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushRun
	tst	#$04,joytrg	;This is SELECT
	bne	.PushSel
	jmp	.NoPushSel
.PushSel:
	lda	#$01
	eor	<menu_on
	sta	<menu_on	;Toggle menu
	beq	.hide_sprite	;Sprite hidden if menu is off	
	bbr0	<quality,.no_init_all_gfx
		;If "Quality" = 1 (high)...
		;Reinitialize the graphics!
	SCREEN_OFF
	stz	<quality	;Back to preview again...
	jsr	setup_video
	jsr	Setup_Horizontal_Res_Vars
	jsr	Print_All_Panels
	smb0	<restart_flag	;Restart fractal
	SCREEN_ON
	jmp	posnspr
;--------------------------
.no_init_all_gfx:
	jsr	Hide_Boxes	;Turns off box mode!
	jsr	Clear_Box_Sides
	spr_set #0,satb
	spr_x sx
	jmp	updspr
.hide_sprite:
	spr_set #0,satb
	spr_x #$0
	bra	updspr
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushSel
	tst	#$01,joytrg	;This is I
	beq	.NoPushI
	bbs0	<quality,.I_Cycle_Up	;If in quality mode, cycle colours
	bbr0	<box_mode,.no_scale_boxI
	jsr	BoxScaleUp
	jmp	updspr
.no_scale_boxI:
	bbr0	<menu_on,.on_box_mode_I
	jsr	IncPanelValue
	jmp	joy_end
;----------------
.on_box_mode_I:
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
.I_Cycle_Up:
	inc	<cycling
	lda	<cycling
	cmp	#$5		;only 4 types of cycling, plus off
	bne	.no_reset_cycling
	stz	<cycling
.no_reset_cycling:
	jmp	joy_end
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushI
	tst	#$02,joytrg	;This is II
	beq	.NoPushII
	bbs0	<quality,.II_Cycle_Dn
	bbr0	<box_mode,.no_scale_boxII
	jsr	BoxScaleDown
	jmp	updspr
.no_scale_boxII:
	bbr0	<menu_on,.on_box_mode_II
	jsr	DecPanelValue
	jmp	joy_end
;----------------
.on_box_mode_II:
	;Now we are in low-quality mode, set up box sprites!
	jsr	Setup_Box_Sprites
	jmp	updspr
.II_Cycle_Dn:
	dec	<cycling
	lda	<cycling
	cmp	#$FF		;only 4 types of cycling, plus off
	bne	.no_loop_cycling
	lda	#$04
	sta	<cycling
.no_loop_cycling:
	jmp	joy_end
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
.NoPushII
	jmp	test_fastj

posnspr:
	jsr	Position_Cursor
updspr:
	jsr	Update_Satb_BLOCKTRANSFER
joy_end:
	lda	#FIRSTJOYDELAY
	sta	joy_delay	;Reset the delay
;-------------------- this should work okay here...
test_fastj:
	bbr0	<box_mode,.no_fast_joy
	jsr	Test_Fast_Joy
.no_fast_joy:
;----------------- Either JOYTRG OR FAST JOY, methinks.
joy_joy_end:		;Happy! happy! joy! joy!
	rts



Test_Fast_Joy:
	lda	joy
	and	#%11110011	;Mask Select and RUN
	beq	.no_fast_movement
	dec	joy_delay
	lda	joy_delay
	bne	.no_check_joy_yet
	lda	#JOYDELAY
	sta	joy_delay	;Reset the delay
;------------------------------ now do the joy checking
	tst	#$02,joy	;This is II
	beq	.NoPushII
	jsr	BoxScaleDown
.NoPushII
	tst	#$01,joy	;This is I
	beq	.NoPushI
	jsr	BoxScaleUp
.NoPushI
	tst	#$20,joy	;This is RIGHT
	beq	.NoPushRight
	jsr	Box_Move_Right
.NoPushRight
	tst	#$80,joy	;This is LEFT
	beq	.NoPushLeft
	jsr	Box_Move_Left
.NoPushLeft
	tst	#$10,joy	;This is UP
	beq	.NoPushUp
	jsr	Box_Move_Up
.NoPushUp
	tst	#$40,joy	;This is DOWN
	beq	.NoPushDown
	jsr	Box_Move_Down
.NoPushDown:
;-----------------------------
.no_check_joy_yet:
.no_fast_movement:
	rts

fast_updspr:
;;;	jsr	Update_Satb_BLOCKTRANSFER
	rts

;=======================================================================


; FRACTAL PRESETS!!

PRESETMAX:	.db	(preset_bytes-preset_text)/16
preset_text:
	.db "STARTUP         "
	.db "THREADS         "
	.db "MINIMAND 1      "
	.db "MINIMAND 2      "
	.db "SPIRALS         "
	.db "LIGHTNING       "
	.db "SEAHORSE        "
	.db "STARBURST       "
	.db "BIFURCATIONS    "
;xxxxxxxxxxxx0123456789ABCDEF
preset_bytes:
	; Startup
	.db $00,$10				;Iter Full
	.db $00,$10				;Iter Preview
	.db $00,$03,$00,$00,$00,$00,$00,$00	;Zoom
	.db $FE,$A0,$00,$00			;Y-Window
	.db $FE,$00,$00,$00			;X-Window
	; Threads
	.db $00,$40				;Iter Full
	.db $00,$20				;Iter Preview
	.db $00,$00,$72,$C0,$00,$00,$00,$00	;Zoom
	.db $FF,$CA,$8C,$C6			;Y-Window
	.db $FE,$32,$34,$00			;X-Window
	; Minimand 1
	.db $00,$50				;Iter Full
	.db $00,$20				;Iter Preview
	.db $00,$00,$0A,$26,$C0,$00,$00,$00	;Zoom
	.db $FE,$F2,$83,$B8			;Y-Window
	.db $FF,$D2,$68,$00			;X-Window
	; Minimand 2
	.db $01,$00				;Iter Full
	.db $00,$50				;Iter Preview
	.db $00,$00,$00,$0B,$28,$EE,$EE,$00	;Zoom
	.db $FE,$F9,$58,$CA			;Y-Window
	.db $FF,$D9,$DC,$5B			;X-Window
	; Spirals
	.db $00,$50				;Iter Full
	.db $00,$30				;Iter Preview
	.db $00,$00,$04,$96,$20,$00,$00,$00	;Zoom
	.db $00,$2B,$3E,$23			;Y-Window
	.db $FF,$30,$1D,$20			;X-Window
	; Lightning
	.db $00,$40				;Iter Full
	.db $00,$20				;Iter Preview
	.db $00,$00,$07,$5C,$60,$00,$00,$00	;Zoom
	.db $00,$4D,$67,$E1			;Y-Window
	.db $FF,$0F,$F2,$84			;X-Window
	; Seahorse
	.db $00,$80				;Iter Full
	.db $00,$50				;Iter Preview
	.db $00,$00,$00,$37,$46,$F1,$C0,$00	;Zoom
	.db $FF,$C8,$77,$86			;Y-Window
	.db $FF,$43,$51,$FE			;X-Window
	; Starburst
	.db $00,$C0				;Iter Full
	.db $00,$80				;Iter Preview
	.db $00,$00,$01,$F3,$AE,$00,$00,$00	;Zoom
	.db $00,$2E,$9B,$25			;Y-Window
	.db $FF,$2F,$40,$FA			;X-Window
	; Bifurcations
	.db $00,$70				;Iter Full
	.db $00,$40				;Iter Preview
	.db $00,$00,$00,$A1,$15,$45,$00,$64	;Zoom
	.db $FF,$C6,$F3,$AA			;Y-Window
	.db $FF,$43,$CD,$CA			;X-Window
;**************************************


PanelText:
 ;    1234567891123456789212345678931234567894123456789512345678961234
 .db "PRESET:      X 0123456789ABCDEF            <CONTROLS>           "
 .db "X-WINDOW:    01234567           SELECT: PANEL ON-OFF            "
 .db "Y-WINDOW:    89ABCDEF           RUN: RENDER HIGH-QUALITY FRACTAL"
 .db "ZOOM:        0123456789ABCDEF                                   "
 .db "ITERATIONS:  1234  -PREVIEW-    MOVE PAD,I,II WITH PANEL OFF FOR"
 .db "             ABC0   -FULL-         EASY-TO-USE ZOOM BOX MODE!   "
 .db "CYCLING:     OFF                  IN THIS MODE, SELECT CANCELS  "
 .db "X-RES:       512                    AND RUN ACCEPTS CHANGES.    "
 .db "                                                                "
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	.bank  MAIN_BANK+2
	.org   $4000
blockgfx:
	.VRAM	$1000
	.incchr "Gfx\blocks.pcx",0,0,16,1
textgfx:
	.VRAM	$1100
	.incchr "Gfx\text.pcx"
spritegfx:
	.incspr "Gfx\sprite.pcx"
blockpal:
	.incpal "Gfx\blocks.pcx",0,1
textpal:
	.incpal "Gfx\text.pcx",0,1
sprpal:
	.incpal "Gfx\sprite.pcx",0,1
cyclepal:
	.incpal "Gfx\cycle.pcx",0,16

;:::::::::::::::::::::::::::::::::::::::::::::
	.bank  MAIN_BANK+3
	.org   $6000
howdychr1a:
	.vram	$3800
	.incchr "Gfx\howdy.pcx",0,32,32,4	;All!
howdychr1b:
	.vram	$4800
	.incchr "Gfx\howdy.pcx",0,96,32,4	;All!
;:::::::::::::::::::::::::::::::::::::::::::::
	.bank	MAIN_BANK+4
	.org	$6000
splash_gfx:
	.incchr "Gfx\FracEngine.pcx"	;All!
splash_pal:
	.incpal "Gfx\FracEngine.pcx",2,4	;4 palettes
howdybat:
	.incbat "Gfx\howdy.pcx",$3000,32,23
howdypal:
	.incpal "Gfx\howdy.pcx",0,1

;:::::::::::::::::::::::::::::::::::::::::::::
	.bank	MAIN_BANK+10
	.org	$6000
splash_map:
	 .incbat "Gfx\FracEngine.pcx",$2000,64,23
;:::::::::::::::::::::::::::::::::::::::::::::
	.bank  MAIN_BANK+11
	.org   $6000
howdychr0a:
	.vram	$3000
	.incchr "Gfx\howdy.pcx",0,0,32,4	;All!
howdychr0b:
	.vram	$5800
	.incchr "Gfx\howdy.pcx",0,160,32,3	;All!

;:::::::::::::::::::::::::::::::::::::::::::::


