#include <stdio.h>

unsigned char b[128];

int main (int argc, char *argv[])
{
	FILE *in;

	if (argc != 2) {
		printf("usage : dumpcd <filename>\n");
		exit(1);
	}

	in = fopen(argv[1], "rb");

	if (in == NULL) {
		printf("Error : could not open file %s\n", argv[1]);
		exit(1);
	}

	fread(b, 1, 128, in);

	if (strncmp(b, "SCD\001", 4) != 0) {
		printf("Error : file is not a soft CD file\n");
		fclose(in);
		exit(1);
	}

	while (fread(b, 1, 128, in) == 128)
		printf("%8ld %8ld %s\n", * ((long int *) &b[0]), * ((long int *) &b[4]), &b[8]);

	fclose(in);

	return 0;
}

