        ORG #6000

;  .
BEGIN   XOR A           ;  
        CALL DRIVER
        LD A,0
        JR Z,$+3
        INC A
        LD (MICE),A     ;0-MOUSE NOP
                        ;1-MOUSE YEP
        LD HL,#6080
        LD (CRDS),HL
AGAIN   CALL MOVING     ;
        RET NZ
        CALL PUTPIXEL   ; 
        HALT 
        CALL PUTPIXEL   ;
        JR AGAIN

PUTPIXEL LD DE,(CRDS)
        LD A,D
        AND 7
        LD H,A
        XOR D
        RRA 
        RRA 
        RRA 
        LD L,A
        AND #18
        OR #40
        OR H
        LD H,A
        LD A,L
        AND 7
        RRCA 
        RRCA 
        RRCA 
        LD L,A
        LD A,E
        RRA 
        RRA 
        RRA 
        AND #1F
        OR L
        LD L,A
        LD A,E
        AND 7
        LD (JRPOS+1),A
        LD A,1
JRPOS   JR $
        RLCA 
        RLCA 
        RLCA 
        RLCA 
        RLCA 
        RLCA 
        RLCA 
        XOR (HL)
        LD (HL),A
        RET 

KEYTB   DB #7F,1,16     ;SPACE (FIRE)
        DB #DF,1,2      ;P
        DB #DF,2,1      ;O
        DB #FB,1,8      ;Q
        DB #FD,1,4      ;A
        DB #EF,1,16     ;0     (FIRE)
        DB #EF,2,8      ;9
        DB #EF,4,4      ;8
        DB #EF,8,2      ;7
        DB #EF,16,1     ;6
EKEYTB

KSPD    DB 0,1,1,1,2,2,2,3,3,4,4,5,6,7
SPD8    DB 8,9,10,12,14,16
KSPDE

MOVING  LD A,0
MICE    EQU $-1
        OR A
        LD DE,0
        CALL NZ,DRIVER+6;DE-MOUSE OFFSET
                        ;A-MOUSE
                        ;BUTTONS
        LD (BATON),A
;  
        LD HL,KEYTB
        LD BC,0+(EKEYTB-KEYTB)/3*256
OPR1    LD A,(HL)
        INC HL
        IN A,(#FE)
        AND (HL)
        INC HL
        LD A,C
        JR NZ,$+4
        OR (HL)
        LD C,A
        INC HL
        DJNZ OPR1

        AND #0F         ;   OA
                        ; ?
        JR Z,MOVL       ;  
                        ; 
                        ;  
        LD A,0
SPD     EQU $-1
        CP KSPDE-KSPD-1
        ADC A,0
MOVL    LD (SPD),A
        ADD A,KSPD
        LD L,A
        ADC A,KSPD/256
        SUB L
        LD H,A
        LD B,(HL)       ;B- 
                        ;  
                        ;

        BIT 0,C
        LD A,E
        JR Z,KNL
        SUB B           ;LEFT
        JP PO,$+5
        LD A,128

KNL     BIT 1,C
        JR Z,KNR
        ADD A,B         ;RIGHT
        JP PO,$+5
        LD A,127
KNR     LD E,A

        LD A,D
        BIT 2,C
        JR Z,KND
        ADD A,B         ;DOWN
        JP PO,$+5
        LD A,127

KND     BIT 3,C
        JR Z,KNU
        SUB B
        JP PO,$+5
        LD A,128
KNU     LD D,A
;DE -     
        LD HL,0
CRDS    EQU $-2
        BIT 7,D
        JR Z,DOWN
        LD A,D
        ADD A,H
        LD H,A
        SBC A,A
        AND H
        LD H,A
        JR NODOWN
DOWN    LD A,D
        ADD A,H
        JR NC,$+4
        LD A,#BF
        CP #C0
        JR C,$+4
        LD A,#BF
        LD H,A
NODOWN  BIT 7,E
        JR Z,RIGHT
        LD A,E
        ADD A,L
        LD L,A
        SBC A,A
        AND L
        LD L,A
        JR NORIGHT
RIGHT   LD A,E
        ADD A,L
        JR NC,$+3
        SBC A,A
        LD L,A
NORIGHT LD (CRDS),HL

;     .
        LD A,C
        RRA 
        RRA 
        RRA 
        RRA 
        AND 3
        OR 0
BATON   EQU $-1
        RET 

; mouse  .C 

;  
MSPD    DB 0,1,2,4,7,10,14,19,25,32,40
MSPDE

DRIVER  JP M_INIT       ; 
                        ;
        JP STOPCUR      ; 

;---------------------------------------
; .   DE  
;  (D-Y, E-X)
; A-    (1 -  )
;0 BIT - FIRE
;1 BIT - CANCEL
;---------------------------------------
GMOUSE  LD A,(MSPDE-1)
        LD D,A
        LD E,A
                        ; DE--
                        ;   
                        ; 
        LD A,#FF        ; 
        IN A,(#DF)      ; Y

        LD C,0          ;   
OLD_FF  EQU $-1         ; Y
        LD (OLD_FF),A
        SUB C           ; A- 
                        ; 

        JP P,M_UP
;  
        NEG 
        CP MSPDE-MSPD
        JR NC,GMDX
        ADD A,MSPD      ;  
        LD L,A          ; Y  
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD D,(HL)
        JR GMDX

M_UP    CP MSPDE-MSPD   ; 
        JR NC,GMU1
        ADD A,MSPD
        LD L,A
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD D,(HL)
GMU1    XOR A
        SUB D
        LD D,A
;   Y  .
GMDX
;       X
        LD A,#FB
        IN A,(#DF)
        LD C,0
OLD_FB  EQU $-1
        LD (OLD_FB),A
        SUB C
        JP M,M_LF
        CP MSPDE-MSPD
        JR NC,MBATON
        ADD A,MSPD
        LD L,A
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD E,(HL)
        JR MBATON
M_LF    NEG 
        CP MSPDE-MSPD
        JR NC,GML1
        ADD A,MSPD
        LD L,A
        ADC A,'MSPD
        SUB L
        LD H,A
        LD E,(HL)
GML1    XOR A
        SUB E
        LD E,A
; DE     
MBATON  ;  
        LD A,0
REVBTN  EQU $-1
        OR A
        LD A,#FA
        IN A,(#DF)
        CPL 
        JR NZ,REVERSE;  
        AND 3
        RET 
REVERSE RRA 
        RL L
        RRA 
        RR L
        LD A,L
        AND 3
        RET 

;---------------------------------------
;  
;  :
; . A:
;  #00 -    
;  #FF -   

;   (    )
; ZF
; 0 -    
; 1 -      

;---------------------------------------
M_INIT  LD (REVBTN),A
        CALL STOPCUR    ; 
        EI              ;
                        ;
                        ;   
                        ; ,
                        ; 
                        ; 
                        ;  
                        ;
                        ;     
                        ; (
                        ;   -
                        ;   #FF
        HALT            ; O 
        LD BC,#FFDF     ; 
        IN A,(C)        ;  
        LD B,#FB        ;   ,
        IN E,(C)        ;, 
        DEC B           ; 
        IN D,(C)        ;.
        CP E
        RET NZ
        SUB D
        RET 
;---------------------------------------
;  
STOPCUR LD A,#FF
        IN A,(#DF)
        LD (OLD_FF),A
        LD A,#FB
        IN A,(#DF)
        LD (OLD_FB),A
        RET 
;---------------------------------------

